#include "misc/htmlnames.h"
#include "dom/dom_string.h"

using namespace DOM;

namespace khtml {

IDTable<NamespaceFactory>* NamespaceFactory::s_idTable;
IDTable<NamespaceFactory>* NamespaceFactory::initIdTable()
{
    if (s_idTable) return s_idTable; // Can happen if KHTMLGlobal was recreated..
    s_idTable = new IDTable<NamespaceFactory>();
    s_idTable->addStaticMapping(DOM::xmlNamespace, XML_NAMESPACE);
    s_idTable->addStaticMapping(DOM::xmlnsNamespace, XMLNS_NAMESPACE);
    s_idTable->addStaticMapping(DOM::svgNamespace, SVG_NAMESPACE);
    s_idTable->addStaticMapping(DOM::xlinkNamespace, XLINK_NAMESPACE);
    s_idTable->addStaticMapping(DOM::xhtmlNamespace, XHTML_NAMESPACE);
    s_idTable->addStaticMapping(DOM::emptyNamespace, DOMString());
    return s_idTable;
}

IDTable<LocalNameFactory>* LocalNameFactory::s_idTable;
IDTable<LocalNameFactory>* LocalNameFactory::initIdTable()
{
    if (s_idTable) return s_idTable; // Can happen if KHTMLGlobal was recreated..
    s_idTable = new IDTable<LocalNameFactory>();
    s_idTable->addStaticMapping(0, DOMString());
    s_idTable->addStaticMapping(localNamePart(ID_A), "a");
    s_idTable->addStaticMapping(localNamePart(ID_ABBR), "abbr");
    s_idTable->addStaticMapping(localNamePart(ID_ACRONYM), "acronym");
    s_idTable->addStaticMapping(localNamePart(ID_ADDRESS), "address");
    s_idTable->addStaticMapping(localNamePart(ID_APPLET), "applet");
    s_idTable->addStaticMapping(localNamePart(ID_AREA), "area");
    s_idTable->addStaticMapping(localNamePart(ID_AUDIO), "audio");
    s_idTable->addStaticMapping(localNamePart(ID_B), "b");
    s_idTable->addStaticMapping(localNamePart(ID_BASE), "base");
    s_idTable->addStaticMapping(localNamePart(ID_BASEFONT), "basefont");
    s_idTable->addStaticMapping(localNamePart(ID_BDO), "bdo");
    s_idTable->addStaticMapping(localNamePart(ID_BIG), "big");
    s_idTable->addStaticMapping(localNamePart(ID_BLOCKQUOTE), "blockquote");
    s_idTable->addStaticMapping(localNamePart(ID_BODY), "body");
    s_idTable->addStaticMapping(localNamePart(ID_BR), "br");
    s_idTable->addStaticMapping(localNamePart(ID_BUTTON), "button");
    s_idTable->addStaticMapping(localNamePart(ID_CANVAS), "canvas");
    s_idTable->addStaticMapping(localNamePart(ID_CAPTION), "caption");
    s_idTable->addStaticMapping(localNamePart(ID_CENTER), "center");
    s_idTable->addStaticMapping(localNamePart(ID_CITE), "cite");
    s_idTable->addStaticMapping(localNamePart(ID_CODE), "code");
    s_idTable->addStaticMapping(localNamePart(ID_COL), "col");
    s_idTable->addStaticMapping(localNamePart(ID_COLGROUP), "colgroup");
    s_idTable->addStaticMapping(localNamePart(ID_DD), "dd");
    s_idTable->addStaticMapping(localNamePart(ID_DEL), "del");
    s_idTable->addStaticMapping(localNamePart(ID_DFN), "dfn");
    s_idTable->addStaticMapping(localNamePart(ID_DIR), "dir");
    s_idTable->addStaticMapping(localNamePart(ID_DIV), "div");
    s_idTable->addStaticMapping(localNamePart(ID_DL), "dl");
    s_idTable->addStaticMapping(localNamePart(ID_DT), "dt");
    s_idTable->addStaticMapping(localNamePart(ID_EM), "em");
    s_idTable->addStaticMapping(localNamePart(ID_EMBED), "embed");
    s_idTable->addStaticMapping(localNamePart(ID_FIELDSET), "fieldset");
    s_idTable->addStaticMapping(localNamePart(ID_FONT), "font");
    s_idTable->addStaticMapping(localNamePart(ID_FORM), "form");
    s_idTable->addStaticMapping(localNamePart(ID_FRAME), "frame");
    s_idTable->addStaticMapping(localNamePart(ID_FRAMESET), "frameset");
    s_idTable->addStaticMapping(localNamePart(ID_H1), "h1");
    s_idTable->addStaticMapping(localNamePart(ID_H2), "h2");
    s_idTable->addStaticMapping(localNamePart(ID_H3), "h3");
    s_idTable->addStaticMapping(localNamePart(ID_H4), "h4");
    s_idTable->addStaticMapping(localNamePart(ID_H5), "h5");
    s_idTable->addStaticMapping(localNamePart(ID_H6), "h6");
    s_idTable->addStaticMapping(localNamePart(ID_HEAD), "head");
    s_idTable->addStaticMapping(localNamePart(ID_HR), "hr");
    s_idTable->addStaticMapping(localNamePart(ID_HTML), "html");
    s_idTable->addStaticMapping(localNamePart(ID_I), "i");
    s_idTable->addStaticMapping(localNamePart(ID_IFRAME), "iframe");
    s_idTable->addStaticMapping(localNamePart(ID_ILAYER), "ilayer");
    s_idTable->addStaticMapping(localNamePart(ID_IMAGE), "image");
    s_idTable->addStaticMapping(localNamePart(ID_IMG), "img");
    s_idTable->addStaticMapping(localNamePart(ID_INPUT), "input");
    s_idTable->addStaticMapping(localNamePart(ID_INS), "ins");
    s_idTable->addStaticMapping(localNamePart(ID_ISINDEX), "isindex");
    s_idTable->addStaticMapping(localNamePart(ID_KBD), "kbd");
    s_idTable->addStaticMapping(localNamePart(ID_KEYGEN), "keygen");
    s_idTable->addStaticMapping(localNamePart(ID_LABEL), "label");
    s_idTable->addStaticMapping(localNamePart(ID_LAYER), "layer");
    s_idTable->addStaticMapping(localNamePart(ID_LEGEND), "legend");
    s_idTable->addStaticMapping(localNamePart(ID_LI), "li");
    s_idTable->addStaticMapping(localNamePart(ID_LINK), "link");
    s_idTable->addStaticMapping(localNamePart(ID_LISTING), "listing");
    s_idTable->addStaticMapping(localNamePart(ID_MAP), "map");
    s_idTable->addStaticMapping(localNamePart(ID_MARQUEE), "marquee");
    s_idTable->addStaticMapping(localNamePart(ID_MENU), "menu");
    s_idTable->addStaticMapping(localNamePart(ID_META), "meta");
    s_idTable->addStaticMapping(localNamePart(ID_NOBR), "nobr");
    s_idTable->addStaticMapping(localNamePart(ID_NOEMBED), "noembed");
    s_idTable->addStaticMapping(localNamePart(ID_NOFRAMES), "noframes");
    s_idTable->addStaticMapping(localNamePart(ID_NOSCRIPT), "noscript");
    s_idTable->addStaticMapping(localNamePart(ID_NOLAYER), "nolayer");
    s_idTable->addStaticMapping(localNamePart(ID_OBJECT), "object");
    s_idTable->addStaticMapping(localNamePart(ID_OL), "ol");
    s_idTable->addStaticMapping(localNamePart(ID_OPTGROUP), "optgroup");
    s_idTable->addStaticMapping(localNamePart(ID_OPTION), "option");
    s_idTable->addStaticMapping(localNamePart(ID_P), "p");
    s_idTable->addStaticMapping(localNamePart(ID_PARAM), "param");
    s_idTable->addStaticMapping(localNamePart(ID_PLAINTEXT), "plaintext");
    s_idTable->addStaticMapping(localNamePart(ID_PRE), "pre");
    s_idTable->addStaticMapping(localNamePart(ID_Q), "q");
    s_idTable->addStaticMapping(localNamePart(ID_S), "s");
    s_idTable->addStaticMapping(localNamePart(ID_SAMP), "samp");
    s_idTable->addStaticMapping(localNamePart(ID_SCRIPT), "script");
    s_idTable->addStaticMapping(localNamePart(ID_SELECT), "select");
    s_idTable->addStaticMapping(localNamePart(ID_SMALL), "small");
    s_idTable->addStaticMapping(localNamePart(ID_SOURCE), "source");
    s_idTable->addStaticMapping(localNamePart(ID_SPAN), "span");
    s_idTable->addStaticMapping(localNamePart(ID_STRIKE), "strike");
    s_idTable->addStaticMapping(localNamePart(ID_STRONG), "strong");
    s_idTable->addStaticMapping(localNamePart(ID_STYLE), "style");
    s_idTable->addStaticMapping(localNamePart(ID_SUB), "sub");
    s_idTable->addStaticMapping(localNamePart(ID_SUP), "sup");
    s_idTable->addStaticMapping(localNamePart(ID_TABLE), "table");
    s_idTable->addStaticMapping(localNamePart(ID_TBODY), "tbody");
    s_idTable->addStaticMapping(localNamePart(ID_TD), "td");
    s_idTable->addStaticMapping(localNamePart(ID_TEXTAREA), "textarea");
    s_idTable->addStaticMapping(localNamePart(ID_TFOOT), "tfoot");
    s_idTable->addStaticMapping(localNamePart(ID_TH), "th");
    s_idTable->addStaticMapping(localNamePart(ID_THEAD), "thead");
    s_idTable->addStaticMapping(localNamePart(ID_TITLE), "title");
    s_idTable->addStaticMapping(localNamePart(ID_TR), "tr");
    s_idTable->addStaticMapping(localNamePart(ID_TT), "tt");
    s_idTable->addStaticMapping(localNamePart(ID_U), "u");
    s_idTable->addStaticMapping(localNamePart(ID_UL), "ul");
    s_idTable->addStaticMapping(localNamePart(ID_VAR), "var");
    s_idTable->addStaticMapping(localNamePart(ID_VIDEO), "video");
    s_idTable->addStaticMapping(localNamePart(ID_WBR), "wbr");
    s_idTable->addStaticMapping(localNamePart(ID_XMP), "xmp");
    s_idTable->addHiddenMapping(ID_TEXT, "text");
    s_idTable->addHiddenMapping(ID_COMMENT, "comment");
    s_idTable->addStaticMapping(localNamePart(ATTR_ACCEPT_CHARSET), "accept-charset");
    s_idTable->addStaticMapping(localNamePart(ATTR_ACCEPT), "accept");
    s_idTable->addStaticMapping(localNamePart(ATTR_ACCESSKEY), "accesskey");
    s_idTable->addStaticMapping(localNamePart(ATTR_ALIGN), "align");
    s_idTable->addStaticMapping(localNamePart(ATTR_ALINK), "alink");
    s_idTable->addStaticMapping(localNamePart(ATTR_AUTOCOMPLETE), "autocomplete");
    s_idTable->addStaticMapping(localNamePart(ATTR_AUTOPLAY), "autoplay");
    s_idTable->addStaticMapping(localNamePart(ATTR_AXIS), "axis");
    s_idTable->addStaticMapping(localNamePart(ATTR_BEHAVIOR), "behavior");
    s_idTable->addStaticMapping(localNamePart(ATTR_BGCOLOR), "bgcolor");
    s_idTable->addStaticMapping(localNamePart(ATTR_BGPROPERTIES), "bgproperties");
    s_idTable->addStaticMapping(localNamePart(ATTR_BORDER), "border");
    s_idTable->addStaticMapping(localNamePart(ATTR_BORDERCOLOR), "bordercolor");
    s_idTable->addStaticMapping(localNamePart(ATTR_CELLPADDING), "cellpadding");
    s_idTable->addStaticMapping(localNamePart(ATTR_CELLSPACING), "cellspacing");
    s_idTable->addStaticMapping(localNamePart(ATTR_CHAR), "char");
    s_idTable->addStaticMapping(localNamePart(ATTR_CHALLENGE), "challenge");
    s_idTable->addStaticMapping(localNamePart(ATTR_CHAROFF), "charoff");
    s_idTable->addStaticMapping(localNamePart(ATTR_CHARSET), "charset");
    s_idTable->addStaticMapping(localNamePart(ATTR_CHECKED), "checked");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLEAR), "clear");
    s_idTable->addStaticMapping(localNamePart(ATTR_CODETYPE), "codetype");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLOR), "color");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLS), "cols");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLSPAN), "colspan");
    s_idTable->addStaticMapping(localNamePart(ATTR_COMPACT), "compact");
    s_idTable->addStaticMapping(localNamePart(ATTR_CONTENTEDITABLE), "contenteditable");
    s_idTable->addStaticMapping(localNamePart(ATTR_CONTROLS), "controls");
    s_idTable->addStaticMapping(localNamePart(ATTR_COORDS), "coords");
    s_idTable->addStaticMapping(localNamePart(ATTR_DECLARE), "declare");
    s_idTable->addStaticMapping(localNamePart(ATTR_DEFER), "defer");
    s_idTable->addStaticMapping(localNamePart(ATTR_DIRECTION), "direction");
    s_idTable->addStaticMapping(localNamePart(ATTR_DISABLED), "disabled");
    s_idTable->addStaticMapping(localNamePart(ATTR_ENCTYPE), "enctype");
    s_idTable->addStaticMapping(localNamePart(ATTR_FACE), "face");
    s_idTable->addStaticMapping(localNamePart(ATTR_FRAMEBORDER), "frameborder");
    s_idTable->addStaticMapping(localNamePart(ATTR_HEIGHT), "height");
    s_idTable->addStaticMapping(localNamePart(ATTR_HIDDEN), "hidden");
    s_idTable->addStaticMapping(localNamePart(ATTR_HREFLANG), "hreflang");
    s_idTable->addStaticMapping(localNamePart(ATTR_HSPACE), "hspace");
    s_idTable->addStaticMapping(localNamePart(ATTR_HTTP_EQUIV), "http-equiv");
    s_idTable->addStaticMapping(localNamePart(ATTR_ISMAP), "ismap");
    s_idTable->addStaticMapping(localNamePart(ATTR_XML_LANG), "lang");
    s_idTable->addStaticMapping(localNamePart(ATTR_LANGUAGE), "language");
    s_idTable->addStaticMapping(localNamePart(ATTR_LEFT), "left");
    s_idTable->addStaticMapping(localNamePart(ATTR_LEFTMARGIN), "leftmargin");
    s_idTable->addStaticMapping(localNamePart(ATTR_LOOP), "loop");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARGINHEIGHT), "marginheight");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARGINWIDTH), "marginwidth");
    s_idTable->addStaticMapping(localNamePart(ATTR_MAXLENGTH), "maxlength");
    s_idTable->addStaticMapping(localNamePart(ATTR_MEDIA), "media");
    s_idTable->addStaticMapping(localNamePart(ATTR_METHOD), "method");
    s_idTable->addStaticMapping(localNamePart(ATTR_MULTIPLE), "multiple");
    s_idTable->addStaticMapping(localNamePart(ATTR_NOHREF), "nohref");
    s_idTable->addStaticMapping(localNamePart(ATTR_NORESIZE), "noresize");
    s_idTable->addStaticMapping(localNamePart(ATTR_NOSAVE), "nosave");
    s_idTable->addStaticMapping(localNamePart(ATTR_NOSHADE), "noshade");
    s_idTable->addStaticMapping(localNamePart(ATTR_NOWRAP), "nowrap");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONABORT), "onabort");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONERROR), "onerror");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONRESIZE), "onresize");
    s_idTable->addStaticMapping(localNamePart(ATTR_OVERSRC), "oversrc");
    s_idTable->addStaticMapping(localNamePart(ATTR_PAGEX), "pagex");
    s_idTable->addStaticMapping(localNamePart(ATTR_PAGEY), "pagey");
    s_idTable->addStaticMapping(localNamePart(ATTR_PLACEHOLDER), "placeholder");
    s_idTable->addStaticMapping(localNamePart(ATTR_PLAIN), "plain");
    s_idTable->addStaticMapping(localNamePart(ATTR_PLUGINPAGE), "pluginpage");
    s_idTable->addStaticMapping(localNamePart(ATTR_PLUGINSPAGE), "pluginspage");
    s_idTable->addStaticMapping(localNamePart(ATTR_PLUGINURL), "pluginurl");
    s_idTable->addStaticMapping(localNamePart(ATTR_POSTER), "poster");
    s_idTable->addStaticMapping(localNamePart(ATTR_READONLY), "readonly");
    s_idTable->addStaticMapping(localNamePart(ATTR_REL), "rel");
    s_idTable->addStaticMapping(localNamePart(ATTR_REV), "rev");
    s_idTable->addStaticMapping(localNamePart(ATTR_ROWS), "rows");
    s_idTable->addStaticMapping(localNamePart(ATTR_ROWSPAN), "rowspan");
    s_idTable->addStaticMapping(localNamePart(ATTR_RULES), "rules");
    s_idTable->addStaticMapping(localNamePart(ATTR_SCOPE), "scope");
    s_idTable->addStaticMapping(localNamePart(ATTR_SCROLLAMOUNT), "scrollamount");
    s_idTable->addStaticMapping(localNamePart(ATTR_SCROLLDELAY), "scrolldelay");
    s_idTable->addStaticMapping(localNamePart(ATTR_SCROLLING), "scrolling");
    s_idTable->addStaticMapping(localNamePart(ATTR_SELECTED), "selected");
    s_idTable->addStaticMapping(localNamePart(ATTR_SHAPE), "shape");
    s_idTable->addStaticMapping(localNamePart(ATTR_SIZE), "size");
    s_idTable->addStaticMapping(localNamePart(ATTR_START), "start");
    s_idTable->addStaticMapping(localNamePart(ATTR_TABINDEX), "tabindex");
    s_idTable->addStaticMapping(localNamePart(ATTR_TARGET), "target");
    s_idTable->addStaticMapping(localNamePart(ATTR_TEXT), "text");
    s_idTable->addStaticMapping(localNamePart(ATTR_TOP), "top");
    s_idTable->addStaticMapping(localNamePart(ATTR_TOPMARGIN), "topmargin");
    s_idTable->addStaticMapping(localNamePart(ATTR_TRUESPEED), "truespeed");
    s_idTable->addStaticMapping(localNamePart(ATTR_XLINK_TYPE), "type");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNKNOWN), "unknown");
    s_idTable->addStaticMapping(localNamePart(ATTR_VALIGN), "valign");
    s_idTable->addStaticMapping(localNamePart(ATTR_VALUETYPE), "valuetype");
    s_idTable->addStaticMapping(localNamePart(ATTR_VERSION), "version");
    s_idTable->addStaticMapping(localNamePart(ATTR_VISIBILITY), "visibility");
    s_idTable->addStaticMapping(localNamePart(ATTR_VLINK), "vlink");
    s_idTable->addStaticMapping(localNamePart(ATTR_VSPACE), "vspace");
    s_idTable->addStaticMapping(localNamePart(ATTR_WIDTH), "width");
    s_idTable->addStaticMapping(localNamePart(ATTR_WRAP), "wrap");
    s_idTable->addStaticMapping(localNamePart(ATTR_Z_INDEX), "z-index");
    s_idTable->addStaticMapping(localNamePart(ATTR_ACTION), "action");
    s_idTable->addStaticMapping(localNamePart(ATTR_ALT), "alt");
    s_idTable->addStaticMapping(localNamePart(ATTR_ARCHIVE), "archive");
    s_idTable->addStaticMapping(localNamePart(ATTR_BACKGROUND), "background");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLASS), "class");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLASSID), "classid");
    s_idTable->addStaticMapping(localNamePart(ATTR_CODEBASE), "codebase");
    s_idTable->addStaticMapping(localNamePart(ATTR_CONTENT), "content");
    s_idTable->addStaticMapping(localNamePart(ATTR_DATA), "data");
    s_idTable->addStaticMapping(localNamePart(ATTR_DATETIME), "datetime");
    s_idTable->addStaticMapping(localNamePart(ATTR_FOR), "for");
    s_idTable->addStaticMapping(localNamePart(ATTR_HEADERS), "headers");
    s_idTable->addStaticMapping(localNamePart(ATTR_XLINK_HREF), "href");
    s_idTable->addStaticMapping(localNamePart(ATTR_ID), "id");
    s_idTable->addStaticMapping(localNamePart(ATTR_LONGDESC), "longdesc");
    s_idTable->addStaticMapping(localNamePart(ATTR_NAME), "name");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONBLUR), "onblur");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONCHANGE), "onchange");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONCLICK), "onclick");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONDBLCLICK), "ondblclick");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONFOCUS), "onfocus");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONHASHCHANGE), "onhashchange");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONKEYDOWN), "onkeydown");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONKEYPRESS), "onkeypress");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONKEYUP), "onkeyup");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONLOAD), "onload");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONMESSAGE), "onmessage");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONMOUSEDOWN), "onmousedown");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONMOUSEMOVE), "onmousemove");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONMOUSEOUT), "onmouseout");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONMOUSEOVER), "onmouseover");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONMOUSEUP), "onmouseup");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONRESET), "onreset");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONSELECT), "onselect");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONSCROLL), "onscroll");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONSUBMIT), "onsubmit");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONUNLOAD), "onunload");
    s_idTable->addStaticMapping(localNamePart(ATTR_PROFILE), "profile");
    s_idTable->addStaticMapping(localNamePart(ATTR_PROMPT), "prompt");
    s_idTable->addStaticMapping(localNamePart(ATTR_SCHEME), "scheme");
    s_idTable->addStaticMapping(localNamePart(ATTR_SRC), "src");
    s_idTable->addStaticMapping(localNamePart(ATTR_STANDBY), "standby");
    s_idTable->addStaticMapping(localNamePart(ATTR_SUMMARY), "summary");
    s_idTable->addStaticMapping(localNamePart(ATTR_USEMAP), "usemap");
    s_idTable->addStaticMapping(localNamePart(ATTR_VALUE), "value");
    s_idTable->addStaticMapping(localNamePart(ATTR_XMLNS), "xmlns");
    s_idTable->addStaticMapping(localNamePart(ID_ALTGLYPH), "altGlyph");
    s_idTable->addStaticMapping(localNamePart(ID_ALTGLYPHDEF), "altGlyphDef");
    s_idTable->addStaticMapping(localNamePart(ID_ALTGLYPHITEM), "altGlyphItem");
    s_idTable->addStaticMapping(localNamePart(ID_ANIMATE), "animate");
    s_idTable->addStaticMapping(localNamePart(ID_ANIMATECOLOR), "animateColor");
    s_idTable->addStaticMapping(localNamePart(ID_ANIMATEMOTION), "animateMotion");
    s_idTable->addStaticMapping(localNamePart(ID_ANIMATETRANSFORM), "animateTransform");
    s_idTable->addStaticMapping(localNamePart(ID_SET), "set");
    s_idTable->addStaticMapping(localNamePart(ID_CIRCLE), "circle");
    s_idTable->addStaticMapping(localNamePart(ID_CLIPPATH), "clipPath");
    s_idTable->addStaticMapping(localNamePart(ID_COLOR_PROFILE), "color_profile");
    s_idTable->addStaticMapping(localNamePart(ID_CURSOR), "cursor");
    s_idTable->addStaticMapping(localNamePart(ID_DEFINITION_SRC), "definition_src");
    s_idTable->addStaticMapping(localNamePart(ID_DEFS), "defs");
    s_idTable->addStaticMapping(localNamePart(ID_DESC), "desc");
    s_idTable->addStaticMapping(localNamePart(ID_ELLIPSE), "ellipse");
    s_idTable->addStaticMapping(localNamePart(ID_FEBLEND), "feBlend");
    s_idTable->addStaticMapping(localNamePart(ID_FECOLORMATRIX), "feColorMatrix");
    s_idTable->addStaticMapping(localNamePart(ID_FECOMPONENTTRANSFER), "feComponentTransfer");
    s_idTable->addStaticMapping(localNamePart(ID_FECOMPOSITE), "feComposite");
    s_idTable->addStaticMapping(localNamePart(ID_FECONVOLVEMATRIX), "feConvolveMatrix");
    s_idTable->addStaticMapping(localNamePart(ID_FEDIFFUSELIGHTING), "feDiffuseLighting");
    s_idTable->addStaticMapping(localNamePart(ID_FEDISPLACEMENTMAP), "feDisplacementMap");
    s_idTable->addStaticMapping(localNamePart(ID_FEDISTANTLIGHT), "feDistantLight");
    s_idTable->addStaticMapping(localNamePart(ID_FEFLOOD), "feFlood");
    s_idTable->addStaticMapping(localNamePart(ID_FEFUNCA), "feFuncA");
    s_idTable->addStaticMapping(localNamePart(ID_FEFUNCB), "feFuncB");
    s_idTable->addStaticMapping(localNamePart(ID_FEFUNCG), "feFuncG");
    s_idTable->addStaticMapping(localNamePart(ID_FEFUNCR), "feFuncR");
    s_idTable->addStaticMapping(localNamePart(ID_FEGAUSSIANBLUR), "feGaussianBlur");
    s_idTable->addStaticMapping(localNamePart(ID_FEIMAGE), "feImage");
    s_idTable->addStaticMapping(localNamePart(ID_FEMERGE), "feMerge");
    s_idTable->addStaticMapping(localNamePart(ID_FEMERGENODE), "feMergeNode");
    s_idTable->addStaticMapping(localNamePart(ID_FEMORPHOLOGY), "feMorphology");
    s_idTable->addStaticMapping(localNamePart(ID_FEOFFSET), "feOffset");
    s_idTable->addStaticMapping(localNamePart(ID_FEPOINTLIGHT), "fePointLight");
    s_idTable->addStaticMapping(localNamePart(ID_FESPECULARLIGHTING), "feSpecularLighting");
    s_idTable->addStaticMapping(localNamePart(ID_FESPOTLIGHT), "feSpotLight");
    s_idTable->addStaticMapping(localNamePart(ID_FETILE), "feTile");
    s_idTable->addStaticMapping(localNamePart(ID_FETURBULENCE), "feTurbulence");
    s_idTable->addStaticMapping(localNamePart(ID_FILTER), "filter");
    s_idTable->addStaticMapping(localNamePart(ID_FONT_FACE), "font_face");
    s_idTable->addStaticMapping(localNamePart(ID_FONT_FACE_FORMAT), "font_face_format");
    s_idTable->addStaticMapping(localNamePart(ID_FONT_FACE_NAME), "font_face_name");
    s_idTable->addStaticMapping(localNamePart(ID_FONT_FACE_SRC), "font_face_src");
    s_idTable->addStaticMapping(localNamePart(ID_FONT_FACE_URI), "font_face_uri");
    s_idTable->addStaticMapping(localNamePart(ID_FOREIGNOBJECT), "foreignObject");
    s_idTable->addStaticMapping(localNamePart(ID_G), "g");
    s_idTable->addStaticMapping(localNamePart(ID_GLYPH), "glyph");
    s_idTable->addStaticMapping(localNamePart(ID_GLYPHREF), "glyphRef");
    s_idTable->addStaticMapping(localNamePart(ID_HKERN), "hkern");
    s_idTable->addStaticMapping(localNamePart(ID_LINE), "line");
    s_idTable->addStaticMapping(localNamePart(ID_LINEARGRADIENT), "linearGradient");
    s_idTable->addStaticMapping(localNamePart(ID_MARKER), "marker");
    s_idTable->addStaticMapping(localNamePart(ID_MASK), "mask");
    s_idTable->addStaticMapping(localNamePart(ID_METADATA), "metadata");
    s_idTable->addStaticMapping(localNamePart(ID_MISSING_GLYPH), "missing_glyph");
    s_idTable->addStaticMapping(localNamePart(ID_MPATH), "mpath");
    s_idTable->addStaticMapping(localNamePart(ID_PATH), "path");
    s_idTable->addStaticMapping(localNamePart(ID_PATTERN), "pattern");
    s_idTable->addStaticMapping(localNamePart(ID_POLYGON), "polygon");
    s_idTable->addStaticMapping(localNamePart(ID_POLYLINE), "polyline");
    s_idTable->addStaticMapping(localNamePart(ID_RADIALGRADIENT), "radialGradient");
    s_idTable->addStaticMapping(localNamePart(ID_RECT), "rect");
    s_idTable->addStaticMapping(localNamePart(ID_STOP), "stop");
    s_idTable->addStaticMapping(localNamePart(ID_SVG), "svg");
    s_idTable->addStaticMapping(localNamePart(ID_SWITCH), "switch");
    s_idTable->addStaticMapping(localNamePart(ID_SYMBOL), "symbol");
    s_idTable->addStaticMapping(localNamePart(ID_TEXTPATH), "textPath");
    s_idTable->addStaticMapping(localNamePart(ID_TREF), "tref");
    s_idTable->addStaticMapping(localNamePart(ID_TSPAN), "tspan");
    s_idTable->addStaticMapping(localNamePart(ID_USE), "use");
    s_idTable->addStaticMapping(localNamePart(ID_VIEW), "view");
    s_idTable->addStaticMapping(localNamePart(ID_VKERN), "vkern");
    s_idTable->addStaticMapping(localNamePart(ATTR_ACCENT_HEIGHT), "accent-height");
    s_idTable->addStaticMapping(localNamePart(ATTR_ACCUMULATE), "accumulate");
    s_idTable->addStaticMapping(localNamePart(ATTR_ADDITIVE), "additive");
    s_idTable->addStaticMapping(localNamePart(ATTR_ALIGNMENT_BASELINE), "alignment-baseline");
    s_idTable->addStaticMapping(localNamePart(ATTR_ALPHABETIC), "alphabetic");
    s_idTable->addStaticMapping(localNamePart(ATTR_AMPLITUDE), "amplitude");
    s_idTable->addStaticMapping(localNamePart(ATTR_ARABIC_FORM), "arabic-form");
    s_idTable->addStaticMapping(localNamePart(ATTR_ASCENT), "ascent");
    s_idTable->addStaticMapping(localNamePart(ATTR_ATTRIBUTENAME), "attributeName");
    s_idTable->addStaticMapping(localNamePart(ATTR_ATTRIBUTETYPE), "attributeType");
    s_idTable->addStaticMapping(localNamePart(ATTR_AZIMUTH), "azimuth");
    s_idTable->addStaticMapping(localNamePart(ATTR_BASEFREQUENCY), "baseFrequency");
    s_idTable->addStaticMapping(localNamePart(ATTR_BASELINE_SHIFT), "baseline-shift");
    s_idTable->addStaticMapping(localNamePart(ATTR_BASEPROFILE), "baseProfile");
    s_idTable->addStaticMapping(localNamePart(ATTR_BBOX), "bbox");
    s_idTable->addStaticMapping(localNamePart(ATTR_BEGIN), "begin");
    s_idTable->addStaticMapping(localNamePart(ATTR_BIAS), "bias");
    s_idTable->addStaticMapping(localNamePart(ATTR_BY), "by");
    s_idTable->addStaticMapping(localNamePart(ATTR_CALCMODE), "calcMode");
    s_idTable->addStaticMapping(localNamePart(ATTR_CAP_HEIGHT), "cap-height");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLIP), "clip");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLIP_PATH), "clip-path");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLIP_RULE), "clip-rule");
    s_idTable->addStaticMapping(localNamePart(ATTR_CLIPPATHUNITS), "clipPathUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLOR_INTERPOLATION), "color-interpolation");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLOR_INTERPOLATION_FILTERS), "color-interpolation-filters");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLOR_PROFILE), "color-profile");
    s_idTable->addStaticMapping(localNamePart(ATTR_COLOR_RENDERING), "color-rendering");
    s_idTable->addStaticMapping(localNamePart(ATTR_CONTENTSCRIPTTYPE), "contentScriptType");
    s_idTable->addStaticMapping(localNamePart(ATTR_CONTENTSTYLETYPE), "contentStyleType");
    s_idTable->addStaticMapping(localNamePart(ATTR_CX), "cx");
    s_idTable->addStaticMapping(localNamePart(ATTR_CY), "cy");
    s_idTable->addStaticMapping(localNamePart(ATTR_D), "d");
    s_idTable->addStaticMapping(localNamePart(ATTR_DESCENT), "descent");
    s_idTable->addStaticMapping(localNamePart(ATTR_DIFFUSECONSTANT), "diffuseConstant");
    s_idTable->addStaticMapping(localNamePart(ATTR_DISPLAY), "display");
    s_idTable->addStaticMapping(localNamePart(ATTR_DIVISOR), "divisor");
    s_idTable->addStaticMapping(localNamePart(ATTR_DOMINANT_BASELINE), "dominant-baseline");
    s_idTable->addStaticMapping(localNamePart(ATTR_DUR), "dur");
    s_idTable->addStaticMapping(localNamePart(ATTR_DX), "dx");
    s_idTable->addStaticMapping(localNamePart(ATTR_DY), "dy");
    s_idTable->addStaticMapping(localNamePart(ATTR_EDGEMODE), "edgeMode");
    s_idTable->addStaticMapping(localNamePart(ATTR_ELEVATION), "elevation");
    s_idTable->addStaticMapping(localNamePart(ATTR_ENABLE_BACKGROUND), "enable-background");
    s_idTable->addStaticMapping(localNamePart(ATTR_END), "end");
    s_idTable->addStaticMapping(localNamePart(ATTR_EXPONENT), "exponent");
    s_idTable->addStaticMapping(localNamePart(ATTR_EXTERNALRESOURCESREQUIRED), "externalResourcesRequired");
    s_idTable->addStaticMapping(localNamePart(ATTR_FILL), "fill");
    s_idTable->addStaticMapping(localNamePart(ATTR_FILL_OPACITY), "fill-opacity");
    s_idTable->addStaticMapping(localNamePart(ATTR_FILL_RULE), "fill-rule");
    s_idTable->addStaticMapping(localNamePart(ATTR_FILTERRES), "filterRes");
    s_idTable->addStaticMapping(localNamePart(ATTR_FILTERUNITS), "filterUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_FLOOD_COLOR), "flood-color");
    s_idTable->addStaticMapping(localNamePart(ATTR_FLOOD_OPACITY), "flood-opacity");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_FAMILY), "font-family");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_SIZE), "font-size");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_SIZE_ADJUST), "font-size-adjust");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_STRETCH), "font-stretch");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_STYLE), "font-style");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_VARIANT), "font-variant");
    s_idTable->addStaticMapping(localNamePart(ATTR_FONT_WEIGHT), "font-weight");
    s_idTable->addStaticMapping(localNamePart(ATTR_FORMAT), "format");
    s_idTable->addStaticMapping(localNamePart(ATTR_FROM), "from");
    s_idTable->addStaticMapping(localNamePart(ATTR_FX), "fx");
    s_idTable->addStaticMapping(localNamePart(ATTR_FY), "fy");
    s_idTable->addStaticMapping(localNamePart(ATTR_G1), "g1");
    s_idTable->addStaticMapping(localNamePart(ATTR_G2), "g2");
    s_idTable->addStaticMapping(localNamePart(ATTR_GLYPH_NAME), "glyph-name");
    s_idTable->addStaticMapping(localNamePart(ATTR_GLYPH_ORIENTATION_HORIZONTAL), "glyph-orientation-horizontal");
    s_idTable->addStaticMapping(localNamePart(ATTR_GLYPH_ORIENTATION_VERTICAL), "glyph-orientation-vertical");
    s_idTable->addStaticMapping(localNamePart(ATTR_GRADIENTTRANSFORM), "gradientTransform");
    s_idTable->addStaticMapping(localNamePart(ATTR_GRADIENTUNITS), "gradientUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_HANGING), "hanging");
    s_idTable->addStaticMapping(localNamePart(ATTR_HORIZ_ADV_X), "horiz-adv-x");
    s_idTable->addStaticMapping(localNamePart(ATTR_HORIZ_ORIGIN_X), "horiz-origin-x");
    s_idTable->addStaticMapping(localNamePart(ATTR_HORIZ_ORIGIN_Y), "horiz-origin-y");
    s_idTable->addStaticMapping(localNamePart(ATTR_IDEOGRAPHIC), "ideographic");
    s_idTable->addStaticMapping(localNamePart(ATTR_IMAGE_RENDERING), "image-rendering");
    s_idTable->addStaticMapping(localNamePart(ATTR_IN), "in");
    s_idTable->addStaticMapping(localNamePart(ATTR_IN2), "in2");
    s_idTable->addStaticMapping(localNamePart(ATTR_INTERCEPT), "intercept");
    s_idTable->addStaticMapping(localNamePart(ATTR_K), "k");
    s_idTable->addStaticMapping(localNamePart(ATTR_K1), "k1");
    s_idTable->addStaticMapping(localNamePart(ATTR_K2), "k2");
    s_idTable->addStaticMapping(localNamePart(ATTR_K3), "k3");
    s_idTable->addStaticMapping(localNamePart(ATTR_K4), "k4");
    s_idTable->addStaticMapping(localNamePart(ATTR_KERNELMATRIX), "kernelMatrix");
    s_idTable->addStaticMapping(localNamePart(ATTR_KERNELUNITLENGTH), "kernelUnitLength");
    s_idTable->addStaticMapping(localNamePart(ATTR_KERNING), "kerning");
    s_idTable->addStaticMapping(localNamePart(ATTR_KEYPOINTS), "keyPoints");
    s_idTable->addStaticMapping(localNamePart(ATTR_KEYSPLINES), "keySplines");
    s_idTable->addStaticMapping(localNamePart(ATTR_KEYTIMES), "keyTimes");
    s_idTable->addStaticMapping(localNamePart(ATTR_LENGTHADJUST), "lengthAdjust");
    s_idTable->addStaticMapping(localNamePart(ATTR_LETTER_SPACING), "letter-spacing");
    s_idTable->addStaticMapping(localNamePart(ATTR_LIGHTING_COLOR), "lighting-color");
    s_idTable->addStaticMapping(localNamePart(ATTR_LIMITINGCONEANGLE), "limitingConeAngle");
    s_idTable->addStaticMapping(localNamePart(ATTR_LOCAL), "local");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARKER_END), "marker-end");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARKER_MID), "marker-mid");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARKER_START), "marker-start");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARKERHEIGHT), "markerHeight");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARKERUNITS), "markerUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_MARKERWIDTH), "markerWidth");
    s_idTable->addStaticMapping(localNamePart(ATTR_MASKCONTENTUNITS), "maskContentUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_MASKUNITS), "maskUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_MATHEMATICAL), "mathematical");
    s_idTable->addStaticMapping(localNamePart(ATTR_MAX), "max");
    s_idTable->addStaticMapping(localNamePart(ATTR_MIN), "min");
    s_idTable->addStaticMapping(localNamePart(ATTR_MODE), "mode");
    s_idTable->addStaticMapping(localNamePart(ATTR_NUMOCTAVES), "numOctaves");
    s_idTable->addStaticMapping(localNamePart(ATTR_OFFSET), "offset");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONACTIVATE), "onactivate");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONBEGIN), "onbegin");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONEND), "onend");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONFOCUSIN), "onfocusin");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONFOCUSOUT), "onfocusout");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONREPEAT), "onrepeat");
    s_idTable->addStaticMapping(localNamePart(ATTR_ONZOOM), "onzoom");
    s_idTable->addStaticMapping(localNamePart(ATTR_OPACITY), "opacity");
    s_idTable->addStaticMapping(localNamePart(ATTR_OPERATOR), "operator");
    s_idTable->addStaticMapping(localNamePart(ATTR_ORDER), "order");
    s_idTable->addStaticMapping(localNamePart(ATTR_ORIENT), "orient");
    s_idTable->addStaticMapping(localNamePart(ATTR_ORIENTATION), "orientation");
    s_idTable->addStaticMapping(localNamePart(ATTR_ORIGIN), "origin");
    s_idTable->addStaticMapping(localNamePart(ATTR_OVERFLOW), "overflow");
    s_idTable->addStaticMapping(localNamePart(ATTR_OVERLINE_POSITION), "overline-position");
    s_idTable->addStaticMapping(localNamePart(ATTR_OVERLINE_THICKNESS), "overline-thickness");
    s_idTable->addStaticMapping(localNamePart(ATTR_PANOSE_1), "panose-1");
    s_idTable->addStaticMapping(localNamePart(ATTR_PATHLENGTH), "pathLength");
    s_idTable->addStaticMapping(localNamePart(ATTR_PATTERNCONTENTUNITS), "patternContentUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_PATTERNTRANSFORM), "patternTransform");
    s_idTable->addStaticMapping(localNamePart(ATTR_PATTERNUNITS), "patternUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_POINTER_EVENTS), "pointer-events");
    s_idTable->addStaticMapping(localNamePart(ATTR_POINTS), "points");
    s_idTable->addStaticMapping(localNamePart(ATTR_POINTSATX), "pointsAtX");
    s_idTable->addStaticMapping(localNamePart(ATTR_POINTSATY), "pointsAtY");
    s_idTable->addStaticMapping(localNamePart(ATTR_POINTSATZ), "pointsAtZ");
    s_idTable->addStaticMapping(localNamePart(ATTR_PRESERVEALPHA), "preserveAlpha");
    s_idTable->addStaticMapping(localNamePart(ATTR_PRESERVEASPECTRATIO), "preserveAspectRatio");
    s_idTable->addStaticMapping(localNamePart(ATTR_PRIMITIVEUNITS), "primitiveUnits");
    s_idTable->addStaticMapping(localNamePart(ATTR_R), "r");
    s_idTable->addStaticMapping(localNamePart(ATTR_RADIUS), "radius");
    s_idTable->addStaticMapping(localNamePart(ATTR_REFX), "refX");
    s_idTable->addStaticMapping(localNamePart(ATTR_REFY), "refY");
    s_idTable->addStaticMapping(localNamePart(ATTR_RENDERING_INTENT), "rendering-intent");
    s_idTable->addStaticMapping(localNamePart(ATTR_REPEATCOUNT), "repeatCount");
    s_idTable->addStaticMapping(localNamePart(ATTR_REPEATDUR), "repeatDur");
    s_idTable->addStaticMapping(localNamePart(ATTR_REQUIREDEXTENSIONS), "requiredExtensions");
    s_idTable->addStaticMapping(localNamePart(ATTR_REQUIREDFEATURES), "requiredFeatures");
    s_idTable->addStaticMapping(localNamePart(ATTR_RESTART), "restart");
    s_idTable->addStaticMapping(localNamePart(ATTR_RESULT), "result");
    s_idTable->addStaticMapping(localNamePart(ATTR_ROTATE), "rotate");
    s_idTable->addStaticMapping(localNamePart(ATTR_RX), "rx");
    s_idTable->addStaticMapping(localNamePart(ATTR_RY), "ry");
    s_idTable->addStaticMapping(localNamePart(ATTR_SCALE), "scale");
    s_idTable->addStaticMapping(localNamePart(ATTR_SEED), "seed");
    s_idTable->addStaticMapping(localNamePart(ATTR_SHAPE_RENDERING), "shape-rendering");
    s_idTable->addStaticMapping(localNamePart(ATTR_SLOPE), "slope");
    s_idTable->addStaticMapping(localNamePart(ATTR_SPACING), "spacing");
    s_idTable->addStaticMapping(localNamePart(ATTR_SPECULARCONSTANT), "specularConstant");
    s_idTable->addStaticMapping(localNamePart(ATTR_SPECULAREXPONENT), "specularExponent");
    s_idTable->addStaticMapping(localNamePart(ATTR_SPREADMETHOD), "spreadMethod");
    s_idTable->addStaticMapping(localNamePart(ATTR_STARTOFFSET), "startOffset");
    s_idTable->addStaticMapping(localNamePart(ATTR_STDDEVIATION), "stdDeviation");
    s_idTable->addStaticMapping(localNamePart(ATTR_STEMH), "stemh");
    s_idTable->addStaticMapping(localNamePart(ATTR_STEMV), "stemv");
    s_idTable->addStaticMapping(localNamePart(ATTR_STITCHTILES), "stitchTiles");
    s_idTable->addStaticMapping(localNamePart(ATTR_STOP_COLOR), "stop-color");
    s_idTable->addStaticMapping(localNamePart(ATTR_STOP_OPACITY), "stop-opacity");
    s_idTable->addStaticMapping(localNamePart(ATTR_STRIKETHROUGH_POSITION), "strikethrough-position");
    s_idTable->addStaticMapping(localNamePart(ATTR_STRIKETHROUGH_THICKNESS), "strikethrough-thickness");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE), "stroke");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_DASHARRAY), "stroke-dasharray");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_DASHOFFSET), "stroke-dashoffset");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_LINECAP), "stroke-linecap");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_LINEJOIN), "stroke-linejoin");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_MITERLIMIT), "stroke-miterlimit");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_OPACITY), "stroke-opacity");
    s_idTable->addStaticMapping(localNamePart(ATTR_STROKE_WIDTH), "stroke-width");
    s_idTable->addStaticMapping(localNamePart(ATTR_SURFACESCALE), "surfaceScale");
    s_idTable->addStaticMapping(localNamePart(ATTR_SYSTEMLANGUAGE), "systemLanguage");
    s_idTable->addStaticMapping(localNamePart(ATTR_TABLEVALUES), "tableValues");
    s_idTable->addStaticMapping(localNamePart(ATTR_TARGETX), "targetX");
    s_idTable->addStaticMapping(localNamePart(ATTR_TARGETY), "targetY");
    s_idTable->addStaticMapping(localNamePart(ATTR_TEXT_ANCHOR), "text-anchor");
    s_idTable->addStaticMapping(localNamePart(ATTR_TEXT_DECORATION), "text-decoration");
    s_idTable->addStaticMapping(localNamePart(ATTR_TEXT_RENDERING), "text-rendering");
    s_idTable->addStaticMapping(localNamePart(ATTR_TEXTLENGTH), "textLength");
    s_idTable->addStaticMapping(localNamePart(ATTR_TO), "to");
    s_idTable->addStaticMapping(localNamePart(ATTR_TRANSFORM), "transform");
    s_idTable->addStaticMapping(localNamePart(ATTR_U1), "u1");
    s_idTable->addStaticMapping(localNamePart(ATTR_U2), "u2");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNDERLINE_POSITION), "underline-position");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNDERLINE_THICKNESS), "underline-thickness");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNICODE), "unicode");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNICODE_BIDI), "unicode-bidi");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNICODE_RANGE), "unicode-range");
    s_idTable->addStaticMapping(localNamePart(ATTR_UNITS_PER_EM), "units-per-em");
    s_idTable->addStaticMapping(localNamePart(ATTR_V_ALPHABETIC), "v-alphabetic");
    s_idTable->addStaticMapping(localNamePart(ATTR_V_HANGING), "v-hanging");
    s_idTable->addStaticMapping(localNamePart(ATTR_V_IDEOGRAPHIC), "v-ideographic");
    s_idTable->addStaticMapping(localNamePart(ATTR_V_MATHEMATICAL), "v-mathematical");
    s_idTable->addStaticMapping(localNamePart(ATTR_VALUES), "values");
    s_idTable->addStaticMapping(localNamePart(ATTR_VERT_ADV_Y), "vert-adv-y");
    s_idTable->addStaticMapping(localNamePart(ATTR_VERT_ORIGIN_X), "vert-origin-x");
    s_idTable->addStaticMapping(localNamePart(ATTR_VERT_ORIGIN_Y), "vert-origin-y");
    s_idTable->addStaticMapping(localNamePart(ATTR_VIEWBOX), "viewBox");
    s_idTable->addStaticMapping(localNamePart(ATTR_VIEWTARGET), "viewTarget");
    s_idTable->addStaticMapping(localNamePart(ATTR_WIDTHS), "widths");
    s_idTable->addStaticMapping(localNamePart(ATTR_WORD_SPACING), "word-spacing");
    s_idTable->addStaticMapping(localNamePart(ATTR_WRITING_MODE), "writing-mode");
    s_idTable->addStaticMapping(localNamePart(ATTR_X), "x");
    s_idTable->addStaticMapping(localNamePart(ATTR_X_HEIGHT), "x-height");
    s_idTable->addStaticMapping(localNamePart(ATTR_X1), "x1");
    s_idTable->addStaticMapping(localNamePart(ATTR_X2), "x2");
    s_idTable->addStaticMapping(localNamePart(ATTR_XCHANNELSELECTOR), "xChannelSelector");
    s_idTable->addStaticMapping(localNamePart(ATTR_Y), "y");
    s_idTable->addStaticMapping(localNamePart(ATTR_Y1), "y1");
    s_idTable->addStaticMapping(localNamePart(ATTR_Y2), "y2");
    s_idTable->addStaticMapping(localNamePart(ATTR_YCHANNELSELECTOR), "yChannelSelector");
    s_idTable->addStaticMapping(localNamePart(ATTR_Z), "z");
    s_idTable->addStaticMapping(localNamePart(ATTR_ZOOMANDPAN), "zoomAndPan");
    s_idTable->addStaticMapping(localNamePart(ATTR_XLINK_ACTUATE), "actuate");
    s_idTable->addStaticMapping(localNamePart(ATTR_XLINK_ARCROLE), "arcrole");
    s_idTable->addStaticMapping(localNamePart(ATTR_XLINK_ROLE), "role");
    s_idTable->addStaticMapping(localNamePart(ATTR_XLINK_SHOW), "show");
    s_idTable->addStaticMapping(localNamePart(ATTR_XML_SPACE), "space");
    return s_idTable;
}

IDTable<PrefixFactory>* PrefixFactory::s_idTable;
IDTable<PrefixFactory>* PrefixFactory::initIdTable()
{
    if (s_idTable) return s_idTable; // Can happen if KHTMLGlobal was recreated..
    s_idTable = new IDTable<PrefixFactory>();
    s_idTable->addStaticMapping(DOM::emptyPrefix, DOMString());
    s_idTable->addStaticMapping(DOM::xmlPrefix, "xml");
    s_idTable->addStaticMapping(DOM::xmlnsPrefix, "xmlns");
    return s_idTable;
}

}

namespace DOM {

LocalName emptyLocalName;// = LocalName::fromId(0);
PrefixName emptyPrefixName;// = PrefixName::fromId(0);
NamespaceName emptyNamespaceName;// = NamespaceName::fromId(0);

QString getPrintableName(int id) {
    QString local = QString("null");
    QString namespacename = QString("null");

    if (localNamePart(id) != anyLocalName) {
        DOMString localName = LocalName::fromId(localNamePart(id)).toString();
        if (localName.implementation())
            local = localName.string();
    } else {
        local = "*";
    }

    if (namespacePart(id) != anyNamespace) {
        DOMString namespaceName = NamespaceName::fromId(namespacePart(id)).toString();
        if (namespaceName.implementation())
            namespacename = namespaceName.string();
    } else {
        namespacename = "*";
    }
    return "{ns:" + QString::number(namespacePart(id)) + ",[" + namespacename + "] local:" + QString::number(localNamePart(id)) + ",[" + local + "]}";
}

}
